setwd("<your directory or folder path>")

alpha<- 0.05 
sigma <- 94.53
numdf <- 1    #numerator degrees of freedom
denomdf <- 34 #denominator degrees of freedom
delsig <- c()
ncpcal <- c()
power <- c()
#
# 
# delta is the true difference between the two group means:
#delta <- c(-1.0*sigma, -0.85*sigma, -0.75*sigma, -0.65*sigma, -0.5*sigma, -0.45*sigma, -0.35*sigma, -0.25*sigma, -0.10*sigma, -0.05*sigma, 0.0, 0.05*sigma, 0.1*sigma, 0.15*sigma, 0.25*sigma, 0.35*sigma, 0.45*sigma, 0.5*sigma, 0.65*sigma, 0.75*sigma, 0.85*sigma, 1.0*sigma)
# note that in general delta could be negative (mu1 < mu2), 0 (mu1 = mu2), or positive (mu1 > mu2)
delsig <- seq(from=0.0,to=10.0,by=0.01) #ratio of delta to sigma; use when sigma is unknown
F.crit <- qf(alpha,df1=numdf,df2=denomdf,ncp=0,lower.tail=FALSE)
ncpcal <- 0.5*(delsig*sqrt((denomdf+1)/((numdf+1))))**2 #from Hinkelmann and Kempthorne, vol. 1. p. 174
#
# ncp is called the non-centrality parameter; when the null hypothesis of zero difference is true, then ncp = 0.0
# as the truth departs from the null (i.e., as delta differs from 0), the ncp changes
#

# power is the probability of rejecting the null hypothesis: H0: mu1 - mu2 = 0, given 
# that the true difference is delta.
# Note that if delta = 0, the power is equal to alpha
power <- pf(q=F.crit,df1=numdf,df2=denomdf,ncp=ncpcal,lower.tail=FALSE)


plot(delsig,power,axes=F,main="Power Curve for F Test",xlab="Delta / Sigma",type="b")
axis(side=1,at=seq(0.0,10.0,0.05)) # x-axis, corresponds to delsig
axis(side=2,at=seq(0.0,1.0,0.05)) # y-axis
abline(h=0.95)
abline(h=1.00)
abline(h=alpha)
abline(v=1.256)
df3 <- cbind(numdf,denomdf,alpha,delsig,power)
3
#
# To convert delsig into the units of the response, multiply
# delsig by an estimate of the within-cell standard deviation
# Such an estimate could be the root mean square error (RMSE) term from
# a previous or initial ANOVA
#

write.csv(df3,"20191124 Power for F Test.csv")